<?php
// Assumes $conn (database connection) and $_SESSION['user_id'], $_SESSION['username'], $_SESSION['role'] are available from admin_dashboard.php
// NOTE: Ensure 'config/db_connection.php' is properly included in admin_dashboard.php

// Check if user session data is available
if (!isset($_SESSION['user_id'])) {
    // Fallback or redirection logic if not logged in
    echo "<p class='error'>User not authenticated. Please log in.</p>";
    return;
}

$user_id = $_SESSION['user_id'];
$user_name = $_SESSION['username'] ?? 'Employee Name'; // Use session username
$user_role = $_SESSION['role'] ?? 'Unspecified Role'; // Use session role

// PHP code to handle form submission
$submission_message = "";
$application_date = "";
$application_body = "";

// Check if the form has been submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // 1. Sanitize and store the input data
    $application_date = filter_input(INPUT_POST, 'application_date', FILTER_SANITIZE_STRING);
    $application_body = filter_input(INPUT_POST, 'application_body', FILTER_SANITIZE_STRING);
    
    // Retrieve hidden user data
    $submitted_user_id = filter_input(INPUT_POST, 'user_id', FILTER_SANITIZE_NUMBER_INT);
    $submitted_username = filter_input(INPUT_POST, 'username', FILTER_SANITIZE_STRING);
    $submitted_user_role = filter_input(INPUT_POST, 'user_role', FILTER_SANITIZE_STRING);


    // 2. Perform basic validation
    if (empty($application_date) || empty($application_body)) {
        $submission_message = "<p class='error-message'>Error: Both the Date and the Application Body fields are required.</p>";
    } else {
        // 3. Display Submission Confirmation (This replaces actual processing like emailing)
        
        $submission_message = "<p class='success-message'>Leave Application Submitted Successfully!</p>";
        $submission_message .= "<div class='submission-details'>";
        $submission_message .= "<h3>Collected User/Session Data:</h3>";
        $submission_message .= "<strong>User ID:</strong> " . htmlspecialchars($submitted_user_id) . "<br>";
        $submission_message .= "<strong>Username:</strong> " . htmlspecialchars($submitted_username) . "<br>";
        $submission_message .= "<strong>Role:</strong> " . htmlspecialchars($submitted_user_role) . "<br>";
        $submission_message .= "<h3>Application Details:</h3>";
        $submission_message .= "<strong>Date:</strong> " . htmlspecialchars($application_date) . "<br>";
        $submission_message .= "<strong>Body:</strong> " . nl2br(htmlspecialchars($application_body)) . "</div>";

        // Clear the form fields after successful submission
        $application_date = "";
        $application_body = "";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Leave Application - Cyberlog</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #f4f4f4;
        }
        .container {
            width: 100%;
            max-width: 800px; /* Max width to resemble a document */
            margin: 0 auto;
            background-color: white;
            padding: 40px;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
            position: relative;
        }
        
        /* --- LETTERHEAD STYLING (Fixed Content) --- */
        .header-top {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            border-bottom: 2px solid #0056b3; /* Simulates the blue line */
            padding-bottom: 10px;
            margin-bottom: 20px;
        }
        .logo-text {
            font-size: 36px;
            font-weight: bold;
            color: #0056b3; /* Primary color from logo */
        }
        .contact-info {
            text-align: right;
            font-size: 14px;
        }
        .contact-info p {
            margin: 3px 0;
        }
        .contact-info a {
            color: #333;
            text-decoration: none;
        }
        .footer-line {
            height: 20px;
            background: linear-gradient(to right, #0056b3 30%, #4CAF50 100%);
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
        }
        /* --- END LETTERHEAD STYLING --- */

        /* --- FORM AND INPUT STYLING --- */
        .fixed-green, .recipient-details {
            /* Simulates the green box text */
            background-color: #dff0d8; 
            border: 1px solid #d6e9c6;
            padding: 8px;
            margin-bottom: 5px;
            display: inline-block; /* Allows vertical stacking */
            width: 100%;
            box-sizing: border-box;
            font-weight: bold;
        }
        .recipient-details {
            margin-top: 10px;
            width: 50%; /* Adjust width for placement */
        }
        .date-section {
            display: flex;
            align-items: center;
            margin-bottom: 20px;
        }
        .date-section label {
            font-weight: bold;
            margin-right: 10px;
            background-color: #dff0d8; /* Green box effect for label */
            padding: 8px;
            border: 1px solid #d6e9c6;
        }
        input[type="date"], textarea {
            /* Simulates the Red Box outline */
            border: 2px solid #ff4d4d; 
            padding: 8px;
            box-sizing: border-box;
            font-size: 16px;
        }
        input[type="date"] {
            width: 200px; /* Smaller width for date input */
        }
        textarea {
            width: 100%;
            min-height: 200px;
            resize: vertical;
            margin-top: 5px;
        }
        button {
            background-color: #0056b3;
            color: white;
            padding: 10px 20px;
            border: none;
            cursor: pointer;
            font-size: 16px;
            margin-top: 20px;
        }
        button:hover {
            background-color: #004499;
        }
        .error-message { color: red; font-weight: bold; margin-bottom: 15px; }
        .success-message { color: green; font-weight: bold; margin-bottom: 15px; }
        .submission-details { border: 1px solid #ccc; padding: 15px; margin-top: 15px; background-color: #f9f9f9; }
    </style>
</head>
<body>

<div class="container">
    
    <div class="header-top">
        <div class="logo-area">
            <span class="logo-text">Cyberlog</span>
        </div>
        <div class="contact-info">
            <p>1/6, Block: New- C, Mirpur-1, Dhaka-1216 📍</p>
            <p>info@cyberlog.com.bd ✉️</p>
            <p>www.cyberlog.com.bd 🌐</p>
        </div>
    </div>
    <?php echo $submission_message; ?>

    <form method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
        
        <input type="hidden" name="user_id" value="<?php echo htmlspecialchars($user_id); ?>">
        <input type="hidden" name="username" value="<?php echo htmlspecialchars($username); ?>">
        <input type="hidden" name="user_role" value="<?php echo htmlspecialchars($user_role); ?>">

        <div class="date-section">
            <label for="application_date">Date</label>
            <input 
                type="date" 
                name="application_date" 
                id="application_date"
                required
                value="<?php echo htmlspecialchars($application_date); ?>"
                title="Red box is where user can input date"
            >
        </div>
        
        <div class="recipient-details">
            <p>Hridoy Mustofa</p>
            <p>Founder & CEO,</p>
            <p>Cyberlog Ltd.</p>
            <p>1/6, Block: New- C, Mirpur-1,</p>
            <p>Dhaka-1216, Bangladesh</p>
        </div>
        
        <br>

        <div class="fixed-green" style="width: 300px;">
            Subject: Request for Leave
        </div>

        <div class="fixed-green" style="width: 100px;">
            Dear Sir,
        </div>
        
        <p style="margin-top: 20px; font-weight: bold;">Application Body:</p>
        <textarea 
            name="application_body" 
            required 
            placeholder="Enter the body of your leave application here (e.g., reason, start date, end date, total days)."
            title="Red box is where user can input body of the leave application"
        ><?php echo htmlspecialchars($application_body); ?></textarea>
        
        <div class="recipient-details" style="width: 300px; margin-top: 30px;">
            <p>Sincerely,</p>
            <p style="text-decoration: underline; margin-bottom: 5px;">
                <?php echo htmlspecialchars($username); ?> 
            </p>
            <p><?php echo htmlspecialchars($username); ?></p>
            <p>**<?php echo htmlspecialchars($user_role); ?>**</p>
            <p>Cyberlog Ltd.</p>
        </div>

        <button type="submit">Submit Leave Application</button>
    </form>

    <div class="footer-line"></div>
</div>

</body>
</html>